package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0492s00Service generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

public interface TramiteOS2Service {

	/**
	 * Inserts a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	TramiteOS2 add(TramiteOS2 ab0492s00);

	/**
	 * Updates a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	TramiteOS2 update(TramiteOS2 ab0492s00);

	/**
	 * Finds a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	TramiteOS2 find(TramiteOS2 ab0492s00);

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os2
	 *            OS2
	 *  TramiteOS2
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os2 the os 2
	 * @return the tramite OS 2
	 */
	public TramiteOS2 findLastTramiteByTipo(Long idTipoTramite, OS2 os2);

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteOS2            TramiteOS2
	 *  TramiteOS2
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @return the tramite OS 2
	 */
	public TramiteOS2 findConTareas(TramiteOS2 tramiteOS2);

	/**
	 * Deletes a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 */
	void remove(TramiteOS2 ab0492s00);

	/**
	 * Finds a list of rows in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0492s00>
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TramiteOS2> findAll(TramiteOS2 ab0492s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0492s00 table using like.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0492s00>
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TramiteOS2> findAllLike(TramiteOS2 ab0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0492s00>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<TramiteOS2> filter(TramiteOS2 filterAb0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  searchAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0492s00>>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param searchAb0492s00 the search ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TramiteOS2>> search(TramiteOS2 filterAb0492s00,
			TramiteOS2 searchAb0492s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(TramiteOS2 filterAb0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
